/*
 * Decompiled with CFR 0.152.
 */
package omq.test.exception;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;
import omq.test.exception.ClientInterface;
import omq.test.exception.Trailer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClientTest {
    private ClientInterface client;

    public ClientTest(String type) throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.SERVER_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.SERIALIZER_NAME, type);
        env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
        env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");
        Broker.initBroker(env);
        this.client = Broker.lookup("server", ClientInterface.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{Serializer.java}, {Serializer.gson}, {Serializer.kryo}};
        return Arrays.asList(data);
    }

    @After
    public void stop() throws Exception {
        Broker.stopBroker();
    }

    @Test
    public void addWheels() throws Exception {
        int wheels = 4;
        this.client.addWheels(wheels);
        Thread.sleep(200L);
        int result = this.client.getWheels();
        Assert.assertEquals((long)wheels, (long)result);
    }

    @Test
    public void addHp() throws Exception {
        int hp = 200;
        this.client.addHp(hp);
        Thread.sleep(200L);
        int result = this.client.getHp();
        Assert.assertEquals((long)hp, (long)result);
    }

    @Test
    public void addTrailer() throws Exception {
        Trailer t = new Trailer(1200);
        this.client.addTrailer(t);
        Thread.sleep(200L);
    }

    @Test(expected=UndeclaredThrowableException.class)
    public void getTrailer() throws Exception {
        this.client.getTrailer();
    }

    @Test
    public void setPrice() throws Exception {
        double price = 4999.99;
        this.client.setPrice(price);
        Thread.sleep(200L);
    }

    @Test(expected=ClassCastException.class)
    public void getPrice() throws Exception {
        this.client.getPrice();
    }
}

