package omq.common.util;

import omq.common.util.Serializers.ISerializer;
import omq.common.util.Serializers.KryoImp;
import omq.exception.SerializerException;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * @author Guillermo Guerrero <guillermo.guerrero@estudiants.urv.cat>
 * 
 */
public class Serializer {
	public static ISerializer serializer;

	public static ISerializer getInstance() {
		if (serializer == null) {
			// serializer = new JavaImp();//Working
			serializer = new KryoImp();// Working
			// serializer = new YamlImp();//Working
			// serializer = new JsonImp();
			// serializer = new GsonImp();
			// serializer = new XmlImp();//Working
		}
		return serializer;
	}

	/**
	 * Serializes an object and converts it to a byte-array
	 * 
	 * @param obj
	 * @return byte array
	 * @throws SerializerException
	 */
	public static byte[] serialize(Object obj) throws SerializerException {
		ISerializer instance = getInstance();
		return instance.serialize(obj);
	}

	/**
	 * Deserializes an object
	 * 
	 * @param bytes
	 * @return
	 * @throws SerializerException
	 */
	public static Object deserialize(byte[] bytes) throws SerializerException {
		ISerializer instance = getInstance();
		return instance.deserialize(bytes);
	}
}