package omq.ztest.Serializers;

import java.io.Serializable;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * @author Guillermo Guerrero <guillermo.guerrero@estudiants.urv.cat>
 * 
 */
public class Car implements Serializable {
	private static final long serialVersionUID = 1L;

	enum Trademark {
		MERCEDES, BMW, AUDI, OPEL, FORD
	}

	private int wheels, doors, places;	
	private transient Trademark tradeMark;	
	private String model, color;	
	private boolean haveTrunk;
	private float accelerationTime;
	private long hp;

	
	public Car() {
		super();
		
		model = "";
		color = "";
	}
		
	public Car(int wheels, int doors, int places, Trademark tradeMark, String model, String color, boolean haveTrunk,
			float accelerationTime, long hp) {
		super();
		this.wheels = wheels;
		this.doors = doors;
		this.places = places;
		this.tradeMark = tradeMark;
		this.model = model;
		this.color = color;
		this.haveTrunk = haveTrunk;
		this.accelerationTime = accelerationTime;
		this.hp = hp;
	}

	public int getWheels() {
		return wheels;
	}

	public void setWheels(int wheels) {
		this.wheels = wheels;
	}

	public int getDoors() {
		return doors;
	}

	public void setDoors(int doors) {
		this.doors = doors;
	}

	public int getPlaces() {
		return places;
	}

	public void setPlaces(int places) {
		this.places = places;
	}

	public Trademark getTradeMark() {
		return tradeMark;
	}

	public void setTradeMark(Trademark tradeMark) {
		this.tradeMark = tradeMark;
	}

	public String getModel() {
		return model;
	}

	public void setModel(String model) {
		this.model = model;
	}

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}

	public boolean isHaveTrunk() {
		return haveTrunk;
	}

	public void setHaveTrunk(boolean haveTrunk) {
		this.haveTrunk = haveTrunk;
	}

	public float getAccelerationTime() {
		return accelerationTime;
	}

	public void setAccelerationTime(float accelerationTime) {
		this.accelerationTime = accelerationTime;
	}

	public long getHp() {
		return hp;
	}

	public void setHp(long hp) {
		this.hp = hp;
	}

	public boolean equals(Car obj) {		
		if(this.wheels != obj.wheels){
			return false;
		}
		
		if(this.doors != obj.doors){
			return false;
		}
		
		if(this.places != obj.places){
			return false;
		}
		
		if(this.tradeMark != obj.tradeMark){
			return false;
		}
		
		if(this.model.compareTo(obj.model) != 0){
			return false;
		}
		
		if(this.color.compareTo(obj.color) != 0){
			return false;
		}
		
		if(this.haveTrunk != obj.haveTrunk){
			return false;
		}
		
		if(this.accelerationTime != obj.accelerationTime){
			return false;
		}
		
		if(this.hp != obj.hp){
			return false;
		}
		
		return true;
	}
}
