package omq.ztest.Serializers;

import omq.common.util.Serializers.GsonImp;
import omq.common.util.Serializers.ISerializer;
import omq.common.util.Serializers.JavaImp;
import omq.common.util.Serializers.JsonImp;
import omq.common.util.Serializers.KryoImp;
import omq.common.util.Serializers.XmlImp;
import omq.common.util.Serializers.YamlImp;
import omq.exception.SerializerException;
import omq.ztest.Serializers.Car.Trademark;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * @author Guillermo Guerrero <guillermo.guerrero@estudiants.urv.cat>
 * 
 */
public class Test {

	private static void trySerializer(Object obj, Class<?> clazz, ISerializer serializer) {
		try {		
			long start = System.nanoTime();

			byte[] bArray;
			if (clazz == null) {
				bArray = serializer.serialize(obj);
			} else {
				bArray = serializer.serialize(obj, clazz);
			}

			long end = System.nanoTime();
			long total = end - start;

			System.out.println("=============================================");
			System.out.println("Test -> " + serializer.getClass().getName());
			System.out.println("Serialize Size:" + bArray.length + "|Time: " + total + "ns");

			start = System.nanoTime();

			Object obj2;
			if (clazz == null) {
				obj2 = serializer.deserialize(bArray);
			} else {
				obj2 = serializer.deserialize(bArray, clazz);
			}
			end = System.nanoTime();
			total = end - start;

			System.out.println("Compare --> " + (((Car) obj).equals((Car) obj2)));
			System.out.println("Deserialize Size:" + bArray.length + "|Time: " + total + "ns");
			System.out.println("=============================================");

		} catch (Exception e) {
			e.printStackTrace();
		} 
	}

	private static void tryAllSerializers(Object obj, Class<?> clazz) {
		System.out.println();
		System.out.println();
		System.out.println();
		System.out.println("=============================================");
		System.out.println("===============TEST==========================");
		System.out.println("=============================================");
		System.out.println(clazz + " --- " + obj);
		System.out.println("=============================================");

		System.out.println();
		
		if(clazz != null){
			trySerializer(obj, clazz, new GsonImp());
			trySerializer(obj, clazz, new JsonImp());
		}
		
		trySerializer(obj, clazz, new JavaImp());		
		trySerializer(obj, clazz, new KryoImp());
		trySerializer(obj, clazz, new XmlImp());
		trySerializer(obj, clazz, new YamlImp());
	}

	/**
	 * @param args
	 * @throws SerializerException
	 */
	public static void main(String[] args) {

		Car c1 = new Car();
		Car c2 = new Car(4, 5, 5, Trademark.OPEL, "Astra gtc Diesel", "Blue", true, (float) 4.5, 120);
		
		tryAllSerializers(c1, null);
		tryAllSerializers(c1, Car.class);
		
		tryAllSerializers(c2, null);
		tryAllSerializers(c2, Car.class);
	}

}
