package omq.client.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Properties;

import com.rabbitmq.client.AMQP.BasicProperties;

import omq.common.broker.Broker;
import omq.common.message.Request;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;

/**
 * TODO Aquesta classe s'eliminarà tant bon punt es faci un proxymq més
 * intel·ligent
 * 
 * @author sergi
 * 
 */
public class MultiProxymq implements InvocationHandler {
	private static final String multi = "multi#";

	private String uid;
	private Broker broker;
	private Serializer serializer;
	private String replyQueueName;
	private String exchange;
	private static final String routingkey = "";
	private transient String serializerType;

	public MultiProxymq(String uid, Class<?> clazz, Broker broker) throws Exception {
		this.uid = uid;
		this.broker = broker;
		serializer = broker.getSerializer();

		Properties env = broker.getEnvironment();
		replyQueueName = env.getProperty(ParameterQueue.RPC_REPLY_QUEUE);
		exchange = multi + env.getProperty(ParameterQueue.RPC_EXCHANGE);
		serializerType = env.getProperty(ParameterQueue.SERIALIZER_NAME, Serializer.JAVA);
	}

	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		String methodName = method.getName();
		String corrId = java.util.UUID.randomUUID().toString();
		boolean multi = true;

		Request request = Request.newAsyncRequest(corrId, methodName, args, multi);

		// Add the correlation ID and create a replyTo property
		BasicProperties props = new BasicProperties.Builder().appId(uid).correlationId(corrId).replyTo(replyQueueName).type(serializerType).build();

		byte[] bytesRequest = serializer.serialize(serializerType, request);
		broker.getChannel().basicPublish(exchange, routingkey, props, bytesRequest);

		return null;
	}

}
