package omq.test.observer;

import java.util.ArrayList;
import java.util.List;

import omq.server.RemoteObject;

public class RemoteSubjectImpl extends RemoteObject implements RemoteSubject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String state;
	private List<RemoteObserver> list = new ArrayList<RemoteObserver>();

	@Override
	public void addObserver(RemoteObserver o) {
		list.add(o);
	}

	@Override
	public void removeObserver(RemoteObserver o) {
		list.remove(o);
	}

	@Override
	public void notifyObservers() {
		for (RemoteObserver o : list) {
			o.update();
		}
	}

	@Override
	public void setState(String state) {
		this.state = state;
	}

	@Override
	public String getStringState() {
		return state;
	}
}
