package omq.test.observer;

import omq.Remote;
import omq.client.annotation.RemoteInterface;
import omq.client.annotation.SyncMethod;

@RemoteInterface
public interface RemoteSubject extends Remote {

	@SyncMethod(timeout = 1000)
	public String getStringState();

	@SyncMethod(timeout = 1000)
	public void setState(String state);

	@SyncMethod(timeout = 1000)
	public void addObserver(RemoteObserver o);

	@SyncMethod(timeout = 1000)
	public void removeObserver(RemoteObserver o);

	@SyncMethod(timeout = 1000)
	public void notifyObservers();
}
