/*
 * Decompiled with CFR 0.152.
 */
package omq.server;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import omq.Remote;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.exception.SerializerException;
import omq.server.RemoteWrapper;
import org.apache.log4j.Logger;

public abstract class RemoteObject
extends Thread
implements Remote {
    private static final long serialVersionUID = -1778953938739846450L;
    private static final String multi = "multi#";
    private static final Logger logger = Logger.getLogger((String)RemoteObject.class.getName());
    private String UID;
    private String multiQueue;
    private Properties env;
    private transient Broker broker;
    private transient RemoteWrapper remoteWrapper;
    private transient Map<String, List<Class<?>>> params;
    private transient Channel channel;
    private transient QueueingConsumer consumer;
    private transient boolean killed = false;
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();

    public void startRemoteObject(String reference, Broker broker, Properties env) throws Exception {
        this.broker = broker;
        this.UID = reference;
        this.multiQueue = this.UID + System.currentTimeMillis();
        this.env = env;
        this.params = new HashMap();
        for (Method m : this.getClass().getMethods()) {
            ArrayList list = new ArrayList();
            for (Class<?> clazz : m.getParameterTypes()) {
                list.add(clazz);
            }
            this.params.put(m.getName(), list);
        }
        int numThreads = Integer.parseInt(env.getProperty(ParameterQueue.NUM_THREADS, "1"));
        this.remoteWrapper = new RemoteWrapper(this, numThreads, broker.getSerializer());
        this.startQueues();
        this.start();
    }

    public void startTriggerEvent(String reference, Broker broker) throws Exception {
        this.broker = broker;
        this.UID = reference;
        if (this.channel == null || !this.channel.isOpen()) {
            this.channel = broker.getChannel();
        }
    }

    @Override
    public void run() {
        while (!this.killed) {
            try {
                QueueingConsumer.Delivery delivery = this.consumer.nextDelivery();
                logger.debug((Object)(this.UID + " has received a message, serializer: " + delivery.getProperties().getType()));
                this.remoteWrapper.notifyDelivery(delivery);
            }
            catch (InterruptedException i) {
                logger.error((Object)i);
            }
            catch (ShutdownSignalException e) {
                logger.error((Object)e);
                try {
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                    this.startQueues();
                }
                catch (Exception e1) {
                    try {
                        long milis = Long.parseLong(this.env.getProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000"));
                        Thread.sleep(milis);
                    }
                    catch (InterruptedException e2) {
                        logger.error((Object)e2);
                    }
                    logger.error((Object)e1);
                }
            }
            catch (ConsumerCancelledException e) {
                logger.error((Object)e);
            }
            catch (SerializerException e) {
                logger.error((Object)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    public String getRef() {
        return this.UID;
    }

    public void kill() throws IOException {
        logger.warn((Object)("Killing objectmq: " + this.getRef()));
        this.killed = true;
        this.interrupt();
        this.channel.close();
        this.remoteWrapper.stopRemoteWrapper();
    }

    public Object invokeMethod(String methodName, Object[] arguments) throws Exception {
        Method method = this.loadMethod(methodName, arguments);
        return method.invoke((Object)this, arguments);
    }

    private Method loadMethod(String methodName, Object[] args) throws NoSuchMethodException {
        Method m = null;
        Class<?> clazz = this.getClass();
        Class[] argArray = null;
        if (args != null) {
            argArray = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argArray[i] = args[i].getClass();
            }
        }
        try {
            m = clazz.getMethod(methodName, argArray);
        }
        catch (NoSuchMethodException nsm) {
            m = this.loadMethodWithPrimitives(methodName, argArray);
        }
        return m;
    }

    private Method loadMethodWithPrimitives(String methodName, Class<?>[] argArray) throws NoSuchMethodException {
        if (argArray != null) {
            Method[] methods = this.getClass().getMethods();
            int length = argArray.length;
            for (Method method : methods) {
                String name = method.getName();
                int argsLength = method.getParameterTypes().length;
                if (!name.equals(methodName) || length != argsLength) continue;
                Class<?>[] params = method.getParameterTypes();
                boolean found = true;
                for (int i = 0; i < length; ++i) {
                    Class<?> paramWrapper;
                    if (!params[i].isPrimitive() || (paramWrapper = primitiveClasses.get(params[i].getName())).equals(argArray[i])) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return method;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public List<Class<?>> getParams(String methodName) {
        return this.params.get(methodName);
    }

    public Channel getChannel() {
        return this.channel;
    }

    private void startQueues() throws Exception {
        String exchange = this.env.getProperty(ParameterQueue.RPC_EXCHANGE);
        String queue = this.UID;
        String routingKey = this.UID;
        String multiExchange = multi + this.UID;
        boolean durable = Boolean.parseBoolean(this.env.getProperty(ParameterQueue.DURABLE_QUEUES, "false"));
        this.channel = this.broker.getNewChannel();
        logger.info((Object)("RemoteObject: " + this.UID + " declaring direct exchange: " + exchange + ", Queue: " + queue + ", Durable: " + durable));
        this.channel.exchangeDeclare(exchange, "direct");
        this.channel.queueDeclare(queue, durable, false, false, null);
        this.channel.queueBind(queue, exchange, routingKey);
        logger.info((Object)("RemoteObject: " + this.UID + " declaring fanout exchange: " + multiExchange + ", Queue: " + this.multiQueue + ", Durable: " + durable));
        this.channel.exchangeDeclare(multiExchange, "fanout");
        this.channel.queueDeclare(this.multiQueue, durable, false, false, null);
        this.channel.queueBind(this.multiQueue, multiExchange, "");
        this.consumer = new QueueingConsumer(this.channel);
        this.channel.basicConsume(queue, true, (Consumer)this.consumer);
        this.channel.basicConsume(this.multiQueue, true, (Consumer)this.consumer);
    }

    static {
        primitiveClasses.put("byte", Byte.class);
        primitiveClasses.put("short", Short.class);
        primitiveClasses.put("char", Character.class);
        primitiveClasses.put("int", Integer.class);
        primitiveClasses.put("long", Long.class);
        primitiveClasses.put("float", Float.class);
        primitiveClasses.put("double", Double.class);
    }
}

