/*
 * Decompiled with CFR 0.152.
 */
package omq.test.multiProcess;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.test.multiProcess.NumberClient;
import omq.test.multiProcess.NumberImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiProcessTest {
    public static Broker broker;
    public static NumberClient remoteNumber;

    public MultiProcessTest(String type) throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.SERVER_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.SERIALIZER_NAME, type);
        env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
        broker = new Broker(env);
        remoteNumber = broker.lookup("number", NumberClient.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"java"}, {"gson"}, {"kryo"}};
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void serverTest() throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.SERVER_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000");
        Broker broker = new Broker(env);
        broker.bind("number", new NumberImpl());
        Broker broker2 = new Broker(env);
        broker2.bind("number", new NumberImpl());
    }

    @After
    public void stop() throws Exception {
        broker.stopBroker();
    }

    @Test
    public void fifoTest() {
        int x = 10;
        remoteNumber.setNumber(x);
        int a = remoteNumber.getNumber();
        Assert.assertEquals((long)0L, (long)a);
        int b = remoteNumber.getNumber();
        Assert.assertEquals((long)x, (long)b);
        remoteNumber.setNumber(0);
        remoteNumber.setNumber(0);
    }

    @Test
    public void multiTest() throws Exception {
        int x = 10;
        remoteNumber.setMultiNumber(x);
        Thread.sleep(200L);
        int a = remoteNumber.getNumber();
        int b = remoteNumber.getNumber();
        Assert.assertEquals((long)x, (long)a);
        Assert.assertEquals((long)x, (long)b);
        int[] number = remoteNumber.getMultiNumber();
        Assert.assertEquals((long)x, (long)number[0]);
        Assert.assertEquals((long)x, (long)number[1]);
        remoteNumber.setMultiNumber(0);
        Thread.sleep(200L);
    }
}

