/*
 * Decompiled with CFR 0.152.
 */
package omq.common.util.Serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import omq.common.message.Request;
import omq.common.message.Response;
import omq.common.util.Serializers.ISerializer;
import omq.exception.SerializerException;
import omq.server.RemoteObject;

public class KryoImp
implements ISerializer {
    private final Kryo kryo = new Kryo();

    @Override
    public byte[] serialize(Object obj) throws SerializerException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Output output = new Output(stream);
            this.kryo.writeObject(output, obj);
            output.flush();
            output.close();
            byte[] bArray = stream.toByteArray();
            stream.flush();
            stream.close();
            return bArray;
        }
        catch (Exception e) {
            throw new SerializerException("Serialize -> " + e.getMessage(), e);
        }
    }

    @Override
    public Request deserializeRequest(byte[] bytes, RemoteObject obj) throws SerializerException {
        return (Request)this.deserializeObject(bytes, Request.class);
    }

    @Override
    public Response deserializeResponse(byte[] bytes, Class<?> type) throws SerializerException {
        return (Response)this.deserializeObject(bytes, Response.class);
    }

    public Object deserializeObject(byte[] bytes, Class<?> type) throws SerializerException {
        try {
            Input input = new Input(bytes);
            Object obj = this.kryo.readObject(input, type);
            input.close();
            return obj;
        }
        catch (Exception e) {
            throw new SerializerException("Deserialize -> " + e.getMessage(), e);
        }
    }
}

