/*
 * Decompiled with CFR 0.152.
 */
package omq.client.proxy;

import com.rabbitmq.client.AMQP;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.UUID;
import omq.common.broker.Broker;
import omq.common.message.Request;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;
import org.apache.log4j.Logger;

public class MultiProxymq
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(MultiProxymq.class.getName());
    private static final String multi = "multi#";
    private String uid;
    private Broker broker;
    private Serializer serializer;
    private String replyQueueName;
    private String exchange;
    private static final String routingkey = "";
    private transient String serializerType;

    public MultiProxymq(String uid, Class<?> clazz, Broker broker) throws Exception {
        this.uid = uid;
        this.broker = broker;
        this.serializer = broker.getSerializer();
        Properties env = broker.getEnvironment();
        this.replyQueueName = env.getProperty(ParameterQueue.RPC_REPLY_QUEUE);
        this.exchange = multi + uid;
        this.serializerType = env.getProperty(ParameterQueue.SERIALIZER_NAME, "java");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        String corrId = UUID.randomUUID().toString();
        boolean multi = true;
        Request request = Request.newAsyncRequest(corrId, methodName, args, multi);
        AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().appId(this.uid).correlationId(corrId).replyTo(this.replyQueueName).type(this.serializerType).build();
        byte[] bytesRequest = this.serializer.serialize(this.serializerType, request);
        this.broker.getChannel().basicPublish(this.exchange, routingkey, props, bytesRequest);
        logger.debug("Proxymq: " + this.uid + " invokes " + methodName + ", corrID" + corrId + ", exchange: " + this.exchange + ", replyQueue: " + this.replyQueueName + ", serializerType: " + this.serializerType + ", multi call: " + request.isMulti() + ", async call: " + request.isAsync());
        return null;
    }
}

