/*
 * Decompiled with CFR 0.152.
 */
package omq.test.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.test.event.Message;
import omq.test.event.MessageImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MessageTest {
    private static final String NAME = "message";
    private static Broker broker;
    private static Message serverProxy;
    private static MessageImpl clientM1;
    private static MessageImpl clientM2;

    public MessageTest(String type) throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.SERVER_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.SERIALIZER_NAME, type);
        env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
        broker = new Broker(env);
        serverProxy = broker.lookupMulti(NAME, Message.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"java"}, {"gson"}, {"kryo"}};
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void client() throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.SERVER_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000");
        Broker broker = new Broker(env);
        clientM1 = new MessageImpl();
        broker.bind(NAME, clientM1);
        Broker broker2 = new Broker(env);
        clientM2 = new MessageImpl();
        broker2.bind(NAME, clientM2);
    }

    @After
    public void stop() throws Exception {
        broker.stopBroker();
    }

    @Test
    public void test() throws Exception {
        String expected = "Hello";
        serverProxy.setMessage(expected);
        Thread.sleep(200L);
        Assert.assertEquals(expected, clientM1.getMessage());
        Assert.assertEquals(expected, clientM2.getMessage());
        serverProxy.setMessage("");
        Thread.sleep(200L);
    }
}

