package omq.common.util;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * 
 */
public class ParameterQueue {

	/*
	 * Properties environment
	 */

	/**
	 * Set the proxy's serializer method
	 */
	public static String PROXY_SERIALIZER = "omq.serializer";

	/**
	 * Set whether the messages must be compressed or not
	 */
	public static String ENABLE_COMPRESSION = "omq.compression";

	/**
	 * Set the ip where the rabbitmq server is.
	 */
	public static String RABBIT_HOST = "omq.host";

	/**
	 * Set the port that rabbitmq uses.
	 */
	public static String RABBIT_PORT = "omq.port";

	/**
	 * Set the clients username
	 */
	public static String USER_NAME = "omq.username";

	/**
	 * Set the clients password
	 */
	public static String USER_PASS = "omq.pass";

	/**
	 * Set the exchange where the objectmq are listening
	 */
	public static String RPC_EXCHANGE = "omq.rpc_exchange";

	/**
	 * Set the clients reply queue. Every client must have a different queue
	 * name.
	 */
	public static String RPC_REPLY_QUEUE = "omq.reply_queue_rpc";

	/**
	 * Set if the queues must be durable. The queues won't be lost when rabbitmq
	 * crashes if DURABLE_QUEUES is set trues.
	 */
	public static String DURABLE_QUEUES = "omq.durable_queue";

	/**
	 * The MESSAGE_TTL_IN_QUEUES controls for how long a message published to
	 * the queues can live before it is discarded. A message that has been in
	 * the queue for longer than the configured TTL is said to be dead.
	 * 
	 * This property must be a non-negative 32 bit integer (0 <= n <= 2^32-1),
	 * describing the TTL period in milliseconds.
	 */
	public static String MESSAGE_TTL_IN_QUEUES = "omq.message_ttl_queue";

	// TODO persistent messages? the messages will be saved in the disk if this
	// flag is set true

	/**
	 * Set if the system will use ssl
	 */
	public static String ENABLE_SSL = "omq.enable_ssl";

	/**
	 * Set how many time we have to wait to retry the connection with the server
	 * when this goes down
	 */
	public static String RETRY_TIME_CONNECTION = "omq.retry_connection";

	/**
	 * Set how many threads will be created to invoke remote methods
	 */
	public static String NUM_THREADS = "omq.num_threads";

	/**
	 * Set the specific name of a multi queue in a specific object
	 */
	public static String MULTI_QUEUE_NAME = "omq.multi_queue_name";

	/**
	 * Set if server will delete a queue when is no longer in use
	 */
	public static String AUTO_DELETE_QUEUE = "omq.auto_delete";

	/**
	 * Set if we are declaring an exclusive queue (restricted to this
	 * connection)
	 */
	public static String EXCLUSIVE_QUEUE = "omq.exclusive_queue";

	/**
	 * Set 1 to indicate the message will be nonpersistent and 2 to indicate it
	 * will be persistent
	 */
	public static String DELIVERY_MODE = "omq.delivery_mode";

	/**
	 * Time in milis
	 */
	public static long DEFAULT_TIMEOUT = 1 * 1000 * 60;

}
