package omq.ztest.calculator;

import omq.server.remote.request.RemoteObject;

public class CalculatorImpl extends RemoteObject implements Calculator {
	private int x = 0;
	private int asyncAdd = 0;

	public CalculatorImpl() throws Exception {
		super();
	}

	private static final long serialVersionUID = 1L;

	public int add(int x, int y) {
		return x + y;
	}

	public void asyncAdd(int x, int y) {
		asyncAdd = x + y;
	}

	public int inc() {
		return ++x;
	}

	public int subs(int x, int y) {
		return x - y;
	}

	public void mult(int x, int y) {
		int mult = (x * y);
		try {
			this.notify(mult);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public int getAsyncAdd() {
		return asyncAdd;
	}

	public void setAsyncAdd(int asyncAdd) {
		this.asyncAdd = asyncAdd;
	}

}
