/*
 * Decompiled with CFR 0.152.
 */
package omq.common.util.Serializers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import omq.common.message.Request;
import omq.common.message.Response;
import omq.common.util.Serializers.ISerializer;
import omq.exception.OmqException;
import omq.exception.SerializerException;
import omq.server.RemoteObject;

public class GsonImp
implements ISerializer {
    private final Gson gson = new Gson();

    @Override
    public byte[] serialize(Object obj) throws SerializerException {
        String json = this.gson.toJson(obj);
        System.out.println(json);
        return json.getBytes();
    }

    @Override
    public Request deserializeRequest(byte[] bytes, RemoteObject obj) throws SerializerException {
        String json = new String(bytes);
        JsonParser parser = new JsonParser();
        JsonObject jsonObj = parser.parse(json).getAsJsonObject();
        String id = jsonObj.get("id").getAsString();
        String method = jsonObj.get("method").getAsString();
        boolean async = jsonObj.get("async").getAsBoolean();
        List<Class<?>> types = obj.getParams(method);
        try {
            JsonArray jsonArgs = (JsonArray)jsonObj.get("params");
            int length = jsonArgs.size();
            Object[] arguments = new Object[length];
            int i = 0;
            for (JsonElement element : jsonArgs) {
                arguments[i] = this.gson.fromJson(element, types.get(i));
                ++i;
            }
            return new Request(id, method, async, arguments);
        }
        catch (NullPointerException e) {
            return new Request(id, method, async, null);
        }
    }

    @Override
    public Response deserializeResponse(byte[] bytes, Class<?> type) throws SerializerException {
        String json = new String(bytes);
        JsonParser parser = new JsonParser();
        JsonObject jsonObj = parser.parse(json).getAsJsonObject();
        String id = jsonObj.get("id").getAsString();
        String idOmq = jsonObj.get("idOmq").getAsString();
        JsonElement jsonElement = jsonObj.get("result");
        Object result = this.gson.fromJson(jsonElement, type);
        JsonElement jsonError = jsonObj.get("error");
        OmqException error = (OmqException)this.gson.fromJson(jsonError, OmqException.class);
        return new Response(id, idOmq, result, error);
    }
}

