/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.impl.ExceptionHandler;
import java.io.IOException;

public class DefaultExceptionHandler
implements ExceptionHandler {
    public void handleUnexpectedConnectionDriverException(Connection conn, Throwable exception) {
    }

    public void handleReturnListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ReturnListener.handleReturn");
    }

    public void handleFlowListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "FlowListener.handleFlow");
    }

    public void handleConfirmListenerException(Channel channel, Throwable exception) {
        this.handleChannelKiller(channel, exception, "ConfirmListener.handle{N,A}ck");
    }

    public void handleConsumerException(Channel channel, Throwable exception, Consumer consumer, String consumerTag, String methodName) {
        this.handleChannelKiller(channel, exception, "Consumer " + consumer + " (" + consumerTag + ")" + " method " + methodName + " for channel " + channel);
    }

    protected void handleChannelKiller(Channel channel, Throwable exception, String what) {
        System.err.println("DefaultExceptionHandler: " + what + " threw an exception for channel " + channel + ":");
        exception.printStackTrace();
        try {
            channel.close(200, "Closed due to exception from " + what);
        }
        catch (AlreadyClosedException ace) {
        }
        catch (IOException ioe) {
            System.err.println("Failure during close of channel " + channel + " after " + exception + ":");
            ioe.printStackTrace();
            channel.getConnection().abort(541, "Internal error closing channel for " + what);
        }
    }
}

