/*
 * Decompiled with CFR 0.152.
 */
package omq.test.stopBroker;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.test.stopBroker.BrokerKiller;
import omq.test.stopBroker.BrokerKillerImpl;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StopBrokerTest {
    private static Broker broker;
    private static BrokerKiller bk;

    public StopBrokerTest(String type) throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.PROXY_SERIALIZER, type);
        env.setProperty(ParameterQueue.ENABLE_COMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
        env.setProperty(ParameterQueue.RETRY_TIME_CONNECTION, "5000");
        broker = new Broker(env);
        bk = broker.lookup("bk", BrokerKiller.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"java"}, {"gson"}, {"kryo"}};
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void server() throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.ENABLE_COMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000");
        Broker broker = new Broker(env);
        BrokerKillerImpl bki = new BrokerKillerImpl(broker);
        broker.bind("bk", bki);
    }

    @After
    public void stop() throws Exception {
        broker.stopBroker();
    }

    @Test
    public void stopBroker() throws Exception {
        bk.killServerBroker();
    }
}

