/*
 * Decompiled with CFR 0.152.
 */
package omq.test.observer;

import java.util.ArrayList;
import java.util.List;
import omq.common.broker.Broker;
import omq.exception.RemoteException;
import omq.server.RemoteObject;
import omq.test.observer.RemoteObserver;
import omq.test.observer.RemoteSubject;

public class RemoteSubjectImpl
extends RemoteObject
implements RemoteSubject {
    private static final long serialVersionUID = 1L;
    private String state;
    private Broker broker;
    private List<RemoteObserver> list;

    public RemoteSubjectImpl(Broker broker) {
        this.broker = broker;
        this.list = new ArrayList<RemoteObserver>();
    }

    @Override
    public void addObserver(String ref) throws RemoteException {
        RemoteObserver obs = this.broker.lookup(ref, RemoteObserver.class);
        this.list.add(obs);
    }

    @Override
    public void removeObserver(String ref) throws RemoteException {
        RemoteObserver obs = this.broker.lookup(ref, RemoteObserver.class);
        this.list.remove(obs);
    }

    @Override
    public void notifyObservers() {
        for (RemoteObserver o : this.list) {
            o.update();
        }
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getStringState() {
        return this.state;
    }
}

