package omq.common.util;

import omq.common.message.Request;
import omq.common.message.Response;
import omq.common.util.Serializers.GsonImp;
import omq.common.util.Serializers.ISerializer;
import omq.exception.SerializerException;
import omq.server.remote.request.RemoteObject;

/**
 * 
 * @author Sergi Toda <sergi.toda@estudiants.urv.cat>
 * @author Guillermo Guerrero <guillermo.guerrero@estudiants.urv.cat>
 * 
 */
public class Serializer {
	public static ISerializer serializer;

	public static ISerializer getInstance() {
		if (serializer == null) {
			serializer = new GsonImp();
			// serializer = new JavaImp();
			// serializer = new KryoImp();
		}
		return serializer;
	}

	public static byte[] serialize(Object obj) throws SerializerException {
		ISerializer instance = getInstance();
		return instance.serialize(obj);
	}

	public static Request deserializeRequest(byte[] bytes, RemoteObject obj) throws SerializerException {
		ISerializer instance = getInstance();
		return instance.deserializeRequest(bytes, obj);
	}

	public static Response deserializeResponse(byte[] bytes, Class<?> type) throws SerializerException {
		ISerializer instance = getInstance();
		return instance.deserializeResponse(bytes, type);
	}
}