package omq.ztest.calculator;

import static org.junit.Assert.assertEquals;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

import org.junit.BeforeClass;
import org.junit.Test;

public class CalculatorTest {
	private static CalculatorImpl calc;
	private static Calculator remoteCalc;

	@BeforeClass
	public static void startServer() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");

		// Get info about the queue & the exchange where the RemoteListener will
		// listen to.
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
		env.setProperty(ParameterQueue.RPC_QUEUE, "rpc_queue");
		env.setProperty(ParameterQueue.RPC_ROUTING_KEY, "rpc");

		calc = new CalculatorImpl();

		Broker.initBroker(env);
		Broker.bind(Calculator.class.getSimpleName(), calc);
	}

	@BeforeClass
	public static void startClient() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Set host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.SERVER_PORT, "5672");

		// Set info about where the message will be sent
		env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
		env.setProperty(ParameterQueue.RPC_ROUTING_KEY, "rpc");

		// Set info about the queue & the exchange where the ResponseListener
		// will listen to.
		env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
		env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");

		Broker.initBroker(env);

		remoteCalc = (Calculator) Broker.lookup(Calculator.class.getSimpleName(), Calculator.class);
	}

	@Test
	public void add() throws Exception {
		int x = 10;
		int y = 20;

		int sync = remoteCalc.add(x, y);
		int sum = x + y;

		assertEquals(sum, sync);
	}

	@Test
	public void mult() throws Exception {
		int x = 5;
		int y = 15;

		remoteCalc.mult(x, y);
		Thread.sleep(200);

		int mult = x * y;

		assertEquals(mult, calc.getMult());
	}
}
