/*
 * Decompiled with CFR 0.152.
 */
package omq.test.multiThread;

import java.util.ArrayList;
import java.util.List;
import omq.common.broker.Broker;
import omq.test.multiThread.Car;
import omq.test.multiThread.Mobile;
import omq.test.multiThread.Rim;

public class CarThread
extends Thread {
    private String name;
    private String tfn;
    private Object lock;

    public CarThread(String name, String tfn, Object lock) {
        this.name = name;
        this.tfn = tfn;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Car car = Broker.lookup(this.name, Car.class);
            car.setHP(1001);
            car.setPlate("California 125");
            ArrayList<Rim> rims = new ArrayList<Rim>();
            rims.add(new Rim("asdf", 17));
            rims.add(new Rim("qwer", 21));
            car.setRims(rims);
            Thread.sleep(1000L);
            System.out.println("HP -> " + car.getHP());
            System.out.println("Plate -> " + car.getPlate());
            for (Rim r : car.getRims()) {
                System.out.println("Rim -> " + r.getModel() + ", " + r.getInch());
            }
            Mobile mobile = Broker.lookup(this.tfn, Mobile.class);
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(2000L);
                List<String> messages = mobile.getMessages();
                for (String m : messages) {
                    System.out.println("Message -> " + m);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

