/*
 * Decompiled with CFR 0.152.
 */
package omq.test.observer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.test.observer.RemoteObserverImpl;
import omq.test.observer.RemoteSubject;
import omq.test.observer.RemoteSubjectImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ObserverTest {
    private static String SUBJECT = "subject";
    private static String OBSERVER = "observer";
    private static Broker broker;
    private static RemoteSubjectImpl subject;
    private static RemoteSubject remoteSubject;

    public ObserverTest(String type) throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.PROXY_SERIALIZER, type);
        env.setProperty(ParameterQueue.ENABLE_COMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
        broker = new Broker(env);
        remoteSubject = broker.lookup(SUBJECT, RemoteSubject.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"java"}, {"gson"}, {"kryo"}};
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void server() throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.ENABLE_COMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "server_reply_queue");
        Broker broker = new Broker(env);
        subject = new RemoteSubjectImpl(broker);
        broker.bind(SUBJECT, subject);
        System.out.println("Server started");
    }

    @After
    public void stop() throws Exception {
        broker.stopBroker();
    }

    @Test
    public void test() throws Exception {
        String expected = "I'm fine";
        String actual = null;
        RemoteObserverImpl observer = new RemoteObserverImpl();
        broker.bind(OBSERVER, observer);
        observer.setSubject(remoteSubject);
        remoteSubject.addObserver(observer.getRef());
        remoteSubject.setState(expected);
        subject.notifyObservers();
        actual = observer.getObsState();
        Assert.assertEquals((Object)expected, (Object)actual);
        remoteSubject.setState("");
    }
}

