/*
 * Decompiled with CFR 0.152.
 */
package omq.test.temporal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.test.calculator.Calculator;
import omq.test.calculator.CalculatorImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProvaTest {
    private static Broker broker;
    private static Calculator remoteCalc;

    @BeforeClass
    public static void serverTest() throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUE, "false");
        env.setProperty(ParameterQueue.ENABLE_COMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000");
        CalculatorImpl calc = new CalculatorImpl();
        Broker broker = new Broker(env);
        broker.bind("calculator1", calc);
        System.out.println("Server started");
    }

    public ProvaTest(String type) throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUE, "false");
        env.setProperty(ParameterQueue.PROXY_SERIALIZER, type);
        env.setProperty(ParameterQueue.ENABLE_COMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
        broker = new Broker(env);
        remoteCalc = broker.lookup("calculator1", Calculator.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"java"}};
        return Arrays.asList(data);
    }

    @After
    public void stop() throws Exception {
        broker.stopBroker();
    }

    @Test
    public void add() throws Exception {
        int x = 10;
        int y = 20;
        int sync = remoteCalc.add(x, y);
        int sum = x + y;
        Assert.assertEquals((long)sum, (long)sync);
    }
}

