/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.LongString;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.SaslMechanism;
import com.rabbitmq.client.impl.LongStringHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class JDKSaslConfig
implements SaslConfig {
    private static final String[] DEFAULT_PREFERRED_MECHANISMS = new String[]{"PLAIN"};
    private final ConnectionFactory factory;
    private final List<String> mechanisms;
    private final CallbackHandler callbackHandler;

    public JDKSaslConfig(ConnectionFactory factory) {
        this(factory, DEFAULT_PREFERRED_MECHANISMS);
    }

    public JDKSaslConfig(ConnectionFactory factory, String[] mechanisms) {
        this.factory = factory;
        this.callbackHandler = new UsernamePasswordCallbackHandler(factory);
        this.mechanisms = Arrays.asList(mechanisms);
    }

    public SaslMechanism getSaslMechanism(String[] serverMechanisms) {
        HashSet<String> server = new HashSet<String>(Arrays.asList(serverMechanisms));
        for (String mechanism : this.mechanisms) {
            if (!server.contains(mechanism)) continue;
            try {
                SaslClient saslClient = Sasl.createSaslClient(new String[]{mechanism}, null, "AMQP", this.factory.getHost(), null, this.callbackHandler);
                if (saslClient == null) continue;
                return new JDKSaslMechanism(saslClient);
            }
            catch (SaslException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private ConnectionFactory factory;

        public UsernamePasswordCallbackHandler(ConnectionFactory factory) {
            this.factory = factory;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.factory.getUsername());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(this.factory.getPassword().toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
    }

    private class JDKSaslMechanism
    implements SaslMechanism {
        private SaslClient client;

        public JDKSaslMechanism(SaslClient client) {
            this.client = client;
        }

        public String getName() {
            return this.client.getMechanismName();
        }

        public LongString handleChallenge(LongString challenge, String username, String password) {
            try {
                return LongStringHelper.asLongString(this.client.evaluateChallenge(challenge.getBytes()));
            }
            catch (SaslException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

