/*
 * Decompiled with CFR 0.152.
 */
package omq.client.listener;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import omq.client.proxy.Proxymq;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import org.apache.log4j.Logger;

public class ResponseListener
extends Thread {
    private final Logger logger = Logger.getLogger(ResponseListener.class.getName());
    private Broker broker;
    private Channel channel;
    private QueueingConsumer consumer;
    private boolean killed = false;
    private Map<String, Map<String, byte[]>> results;
    private Properties env;

    public ResponseListener(Broker broker) throws Exception {
        this.broker = broker;
        this.env = broker.getEnvironment();
        this.results = new Hashtable<String, Map<String, byte[]>>();
        this.startRPCQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info("ResponseListener started");
        while (!this.killed) {
            try {
                Map<String, byte[]> proxyResults;
                QueueingConsumer.Delivery delivery = this.consumer.nextDelivery();
                AMQP.BasicProperties props = delivery.getProperties();
                String uid_request = delivery.getProperties().getCorrelationId();
                this.logger.debug("Response received -> proxy reference: " + props.getAppId() + ", corrId: " + uid_request);
                Map<String, byte[]> map = proxyResults = this.results.get(props.getAppId());
                synchronized (map) {
                    if (!proxyResults.containsKey(uid_request)) {
                        proxyResults.put(uid_request, delivery.getBody());
                        proxyResults.notifyAll();
                    }
                }
            }
            catch (InterruptedException i) {
                this.logger.error(i.toString(), i);
            }
            catch (ShutdownSignalException e) {
                this.logger.error(e.toString(), e);
                try {
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                    this.startRPCQueue();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    try {
                        long milis = Long.parseLong(this.env.getProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000"));
                        Thread.sleep(milis);
                    }
                    catch (InterruptedException e2) {
                        this.logger.error(e2.toString(), e2);
                    }
                }
            }
            catch (ConsumerCancelledException e) {
                this.logger.error(e.toString(), e);
            }
            catch (Exception e) {
                this.logger.error(e.toString(), e);
            }
        }
    }

    private void startRPCQueue() throws Exception {
        this.channel = this.broker.getNewChannel();
        HashMap<String, Object> args = null;
        String reply_queue = this.env.getProperty(ParameterQueue.RPC_REPLY_QUEUE);
        boolean durable = Boolean.parseBoolean(this.env.getProperty(ParameterQueue.DURABLE_QUEUE, "false"));
        boolean exclusive = Boolean.parseBoolean(this.env.getProperty(ParameterQueue.EXCLUSIVE_QUEUE, "true"));
        boolean autoDelete = Boolean.parseBoolean(this.env.getProperty(ParameterQueue.AUTO_DELETE_QUEUE, "true"));
        int ttl = Integer.parseInt(this.env.getProperty(ParameterQueue.MESSAGE_TTL_IN_QUEUES, "-1"));
        if (ttl > 0) {
            args = new HashMap<String, Object>();
            args.put("x-message-ttl", ttl);
        }
        if (reply_queue == null) {
            reply_queue = this.channel.queueDeclare().getQueue();
            this.env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, reply_queue);
        } else {
            this.channel.queueDeclare(reply_queue, durable, exclusive, autoDelete, args);
        }
        this.logger.info("ResponseListener creating queue: " + reply_queue + ", durable: " + durable + ", exclusive: " + exclusive + ", autoDelete: " + autoDelete + ", TTL: " + (ttl > 0 ? Integer.valueOf(ttl) : "not set"));
        this.consumer = new QueueingConsumer(this.channel);
        this.channel.basicConsume(reply_queue, true, this.consumer);
    }

    public boolean containsKey(String key) {
        return this.results.containsKey(key);
    }

    public void kill() throws IOException {
        this.logger.warn("Killing ResponseListener");
        this.interrupt();
        this.killed = true;
        this.channel.close();
    }

    public void registerProxy(Proxymq proxy) {
        if (!this.results.containsKey(proxy.getRef())) {
            this.results.put(proxy.getRef(), proxy.getResults());
        }
    }
}

