/*
 * Decompiled with CFR 0.152.
 */
package omq.client.proxy;

import com.rabbitmq.client.AMQP;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import omq.Remote;
import omq.client.annotation.AsyncMethod;
import omq.client.annotation.SyncMethod;
import omq.client.listener.ResponseListener;
import omq.common.broker.Broker;
import omq.common.event.Event;
import omq.common.event.EventDispatcher;
import omq.common.event.EventListener;
import omq.common.message.Request;
import omq.common.message.Response;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;
import omq.exception.NoContainsInstanceException;
import omq.exception.OmqException;
import omq.exception.RetryException;
import omq.exception.SerializerException;
import omq.exception.TimeoutException;
import org.apache.log4j.Logger;

public class Proxymq
implements InvocationHandler,
Remote {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)Proxymq.class.getName());
    private static Map<String, Object> proxies = new Hashtable<String, Object>();
    private String uid;
    private transient String serializerType;
    private transient ResponseListener rListener;
    private transient EventDispatcher dispatcher;
    private transient Properties env;
    private transient Map<String, byte[]> results;
    private transient Map<String, EventListener<?>> listeners;
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();

    public Proxymq(String uid, Class<?> clazz, Properties env) throws Exception {
        this.uid = uid;
        this.rListener = ResponseListener.getRequestListener();
        this.dispatcher = EventDispatcher.getDispatcher();
        this.env = env;
        this.serializerType = env.getProperty(ParameterQueue.SERIALIZER_NAME, Serializer.java);
        this.listeners = new HashMap();
        this.results = new HashMap<String, byte[]>();
        this.rListener.registerProxy(this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        String methodName = method.getName();
        if (method.getDeclaringClass().equals(Remote.class)) {
            if (methodName.equals("getRef")) {
                return this.getRef();
            }
            if (methodName.equals("addListener")) {
                this.addListener((EventListener)arguments[0]);
                return null;
            }
            if (methodName.equals("removeListener")) {
                this.removeListener((EventListener)arguments[0]);
                return null;
            }
            if (methodName.equals("getListeners")) {
                return this.getListeners();
            }
        }
        Request request = this.createRequest(method, arguments);
        Object response = null;
        if (request.isAsync()) {
            logger.debug((Object)("Publish async request -> " + request.getId()));
            this.publishAsyncRequest(request);
        } else {
            logger.debug((Object)("Publish sync request -> " + request.getId()));
            response = this.publishSyncRequest(request, method.getReturnType());
        }
        return response;
    }

    private void publishMessage(Request request, String replyQueueName) throws Exception {
        String corrId = request.getId();
        String exchange = this.env.getProperty(ParameterQueue.RPC_EXCHANGE);
        String routingkey = this.uid;
        AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().appId(this.uid).correlationId(corrId).replyTo(replyQueueName).type(this.serializerType).build();
        byte[] bytesRequest = Serializer.serialize(this.serializerType, request);
        Broker.getChannel().basicPublish(exchange, routingkey, props, bytesRequest);
    }

    private void publishAsyncRequest(Request request) throws Exception {
        String replyQueueName = this.env.getProperty(ParameterQueue.RPC_REPLY_QUEUE);
        this.publishMessage(request, replyQueueName);
    }

    private Object publishSyncRequest(Request request, Class<?> type) throws Exception {
        String corrId = request.getId();
        int retries = request.getRetries();
        long timeout = request.getTimeout();
        String replyQueueName = this.env.getProperty(ParameterQueue.RPC_REPLY_QUEUE);
        for (int i = 0; i < retries; ++i) {
            try {
                this.publishMessage(request, replyQueueName);
                return this.getResult(corrId, timeout, type);
            }
            catch (TimeoutException te) {
                logger.error((Object)te);
                continue;
            }
        }
        throw new RetryException(retries, timeout);
    }

    private Request createRequest(Method method, Object[] arguments) {
        String corrId = UUID.randomUUID().toString();
        String methodName = method.getName();
        if (method.getAnnotation(AsyncMethod.class) == null) {
            int retries = 1;
            long timeout = ParameterQueue.DEFAULT_TIMEOUT;
            if (method.getAnnotation(SyncMethod.class) != null) {
                SyncMethod sync = method.getAnnotation(SyncMethod.class);
                retries = sync.retry();
                timeout = sync.timeout();
            }
            return Request.newSyncRequest(corrId, methodName, arguments, retries, timeout);
        }
        return Request.newAsyncRequest(corrId, methodName, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getResult(String corrId, long timeout, Class<?> type) throws Exception {
        Response resp = null;
        long localTimeout = 0L;
        long start = System.currentTimeMillis();
        Map<String, byte[]> map = this.results;
        synchronized (map) {
            while (!this.results.containsKey(corrId) && timeout - localTimeout >= 0L) {
                this.results.wait(timeout);
                localTimeout = System.currentTimeMillis() - start;
            }
            if (timeout - localTimeout <= 0L) {
                throw new TimeoutException("Timeout exception time: " + timeout);
            }
            resp = Serializer.deserializeResponse(this.results.get(corrId), type);
            this.results.put(corrId, null);
        }
        if (resp.getError() != null) {
            OmqException error = resp.getError();
            String name = error.getType();
            String message = error.getMessage();
            throw (Exception)Class.forName(name).getConstructor(String.class).newInstance(message);
        }
        return resp.getResult();
    }

    public static boolean containsProxy(String reference) {
        return proxies.containsKey(reference);
    }

    public static Object getInstance(String reference) throws NoContainsInstanceException {
        if (!Proxymq.containsProxy(reference)) {
            throw new NoContainsInstanceException(reference);
        }
        return proxies.get(reference);
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, Proxymq proxy) {
        if (proxies.containsKey(proxy.getRef())) {
            return proxies.get(proxy.getRef());
        }
        Object value = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)proxy);
        proxies.put(proxy.getRef(), value);
        return value;
    }

    public Map<String, byte[]> getResults() {
        return this.results;
    }

    public static void stopProxy() {
        proxies = new HashMap<String, Object>();
    }

    public static Map<String, Object> getProxies() {
        return proxies;
    }

    public static void setProxies(Map<String, Object> proxies) {
        Proxymq.proxies = proxies;
    }

    @Override
    public String getRef() {
        return this.uid;
    }

    @Override
    public void notifyEvent(Event event) throws IOException, SerializerException {
    }

    @Override
    public void addListener(EventListener<?> eventListener) throws Exception {
        if (eventListener.getTopic() == null) {
            eventListener.setTopic(this.uid);
        }
        this.listeners.put(eventListener.getTopic(), eventListener);
        this.dispatcher.addListener(eventListener);
    }

    @Override
    public void removeListener(EventListener<?> eventListener) throws Exception {
        this.listeners.remove(eventListener.getTopic());
        this.dispatcher.removeListener(eventListener);
    }

    @Override
    public Collection<EventListener<?>> getListeners() throws Exception {
        return this.listeners.values();
    }

    static {
        primitiveClasses.put("byte", Byte.class);
        primitiveClasses.put("short", Short.class);
        primitiveClasses.put("char", Character.class);
        primitiveClasses.put("int", Integer.class);
        primitiveClasses.put("long", Long.class);
        primitiveClasses.put("float", Float.class);
        primitiveClasses.put("double", Double.class);
    }
}

