/*
 * Decompiled with CFR 0.152.
 */
package omq.server;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.QueueingConsumer;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;
import omq.common.message.Request;
import omq.common.message.Response;
import omq.common.util.Serializer;
import omq.exception.OmqException;
import omq.server.RemoteObject;
import org.apache.log4j.Logger;

public class InvocationThread
extends Thread {
    private static final Logger logger = Logger.getLogger((String)InvocationThread.class.getName());
    private RemoteObject obj;
    private BlockingQueue<QueueingConsumer.Delivery> deliveryQueue;
    private boolean killed = false;

    public InvocationThread(RemoteObject obj, BlockingQueue<QueueingConsumer.Delivery> deliveryQueue) {
        this.obj = obj;
        this.deliveryQueue = deliveryQueue;
    }

    @Override
    public void run() {
        while (!this.killed) {
            try {
                QueueingConsumer.Delivery delivery = this.deliveryQueue.take();
                String serializerType = delivery.getProperties().getType();
                Request request = Serializer.deserializeRequest(serializerType, delivery.getBody(), this.obj);
                String methodName = request.getMethod();
                String requestID = request.getId();
                logger.debug((Object)("Object: " + this.obj.getRef() + ", method: " + methodName + " corrID: " + requestID));
                Object result = null;
                OmqException error = null;
                try {
                    result = this.obj.invokeMethod(request.getMethod(), request.getParams());
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getTargetException();
                    logger.error((Object)("Object: " + this.obj.getRef() + " at method: " + methodName + ", corrID" + requestID), throwable);
                    error = new OmqException(throwable.getClass().getCanonicalName(), throwable.getMessage());
                }
                catch (NoSuchMethodException e) {
                    logger.error((Object)("Object: " + this.obj.getRef() + " cannot find method: " + methodName));
                    error = new OmqException(e.getClass().getCanonicalName(), e.getMessage());
                }
                if (request.isAsync()) continue;
                Response resp = new Response(request.getId(), this.obj.getRef(), result, error);
                Channel channel = this.obj.getChannel();
                AMQP.BasicProperties props = delivery.getProperties();
                AMQP.BasicProperties replyProps = new AMQP.BasicProperties.Builder().appId(this.obj.getRef()).correlationId(props.getCorrelationId()).build();
                byte[] bytesResponse = Serializer.serialize(serializerType, resp);
                channel.basicPublish("", props.getReplyTo(), replyProps, bytesResponse);
            }
            catch (InterruptedException i) {
                logger.error((Object)i);
                this.killed = true;
            }
            catch (Exception e) {
                logger.error((Object)("Object: " + this.obj.getRef()), (Throwable)e);
            }
        }
    }

    public RemoteObject getObj() {
        return this.obj;
    }

    public void setObj(RemoteObject obj) {
        this.obj = obj;
    }

    public BlockingQueue<QueueingConsumer.Delivery> getDeliveryQueue() {
        return this.deliveryQueue;
    }

    public void setDeliveryQueue(BlockingQueue<QueueingConsumer.Delivery> deliveryQueue) {
        this.deliveryQueue = deliveryQueue;
    }
}

