/*
 * Decompiled with CFR 0.152.
 */
package omq.test.persistence;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.test.persistence.Message;
import omq.test.persistence.MessageImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PersistentTest {
    private static String MESSAGE = "message";
    private String type;
    private Properties clientProps;
    private Properties serverProps;
    private Properties msgImplProps;

    public PersistentTest(String type) {
        this.type = type;
        this.serverProps = new Properties();
        this.serverProps.setProperty(ParameterQueue.USER_NAME, "guest");
        this.serverProps.setProperty(ParameterQueue.USER_PASS, "guest");
        this.serverProps.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
        this.serverProps.setProperty(ParameterQueue.RABBIT_PORT, "5672");
        this.msgImplProps = new Properties();
        this.msgImplProps.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        this.msgImplProps.setProperty(ParameterQueue.DURABLE_QUEUES, "true");
        this.msgImplProps.setProperty(ParameterQueue.EXCLUSIVE_QUEUE, "false");
        this.msgImplProps.setProperty(ParameterQueue.AUTO_DELETE_QUEUE, "false");
        this.msgImplProps.setProperty(ParameterQueue.MULTI_QUEUE_NAME, "multiMessageQueue");
        this.msgImplProps.setProperty(ParameterQueue.DELIVERY_MODE, "1");
        this.clientProps = new Properties();
        this.clientProps.setProperty(ParameterQueue.USER_NAME, "guest");
        this.clientProps.setProperty(ParameterQueue.USER_PASS, "guest");
        this.clientProps.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
        this.clientProps.setProperty(ParameterQueue.RABBIT_PORT, "5672");
        this.clientProps.setProperty(ParameterQueue.DURABLE_QUEUES, "true");
        this.clientProps.setProperty(ParameterQueue.PROXY_SERIALIZER, type);
        this.clientProps.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        this.clientProps.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "persistent_message_reply_queue");
        this.clientProps.setProperty(ParameterQueue.DELIVERY_MODE, "2");
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"java"}, {"gson"}, {"kryo"}};
        return Arrays.asList(data);
    }

    @Test
    public void test() throws Exception {
        System.out.println("Type = " + this.type);
        String expected = "message";
        String actual = null;
        Broker serverBroker = new Broker(this.serverProps);
        MessageImpl msgImpl = new MessageImpl();
        serverBroker.bind(MESSAGE, msgImpl, this.msgImplProps);
        serverBroker.stopBroker();
        Broker clientBroker = new Broker(this.clientProps);
        Message iMsg = clientBroker.lookup(MESSAGE, Message.class);
        iMsg.setMessage(expected);
        String password = "unpc";
        String[] command = new String[]{"/bin/bash", "-c", "echo " + password + " | sudo -S service rabbitmq-server restart"};
        Runtime runtime = Runtime.getRuntime();
        runtime.exec(command);
        Thread.sleep(15000L);
        serverBroker = new Broker(this.serverProps);
        msgImpl = new MessageImpl();
        serverBroker.bind(MESSAGE, msgImpl, this.msgImplProps);
        actual = iMsg.getMessage();
        serverBroker.stopBroker();
        clientBroker.stopBroker();
        Assert.assertEquals(expected, actual);
    }
}

