/*
 * Decompiled with CFR 0.152.
 */
package omq.common.util;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import omq.common.util.ParameterQueue;
import org.apache.log4j.Logger;

public class OmqConnectionFactory {
    private static final Logger logger = Logger.getLogger((String)OmqConnectionFactory.class.getName());
    private static Connection connection;
    private static int connectionTimeout;

    public static void init(Properties env) throws KeyManagementException, NoSuchAlgorithmException, IOException {
        if (connection == null) {
            connection = OmqConnectionFactory.getNewConnection(env);
        }
    }

    public static Connection getNewWorkingConnection(Properties env) throws Exception {
        Connection connection = null;
        boolean working = false;
        while (!working) {
            try {
                connection = OmqConnectionFactory.getNewConnection(env);
                working = true;
            }
            catch (Exception e) {
                logger.error((Object)e);
                long milis = 2000L;
                if (env != null) {
                    milis = Long.parseLong(env.getProperty(ParameterQueue.RETRY_TIME_CONNECTION, "2000"));
                }
                Thread.sleep(milis);
            }
        }
        return connection;
    }

    public static Connection getNewConnection(Properties env) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        String username = env.getProperty(ParameterQueue.USER_NAME);
        String password = env.getProperty(ParameterQueue.USER_PASS);
        String host = env.getProperty(ParameterQueue.RABBIT_HOST);
        int port = Integer.parseInt(env.getProperty(ParameterQueue.RABBIT_PORT));
        boolean ssl = Boolean.parseBoolean(env.getProperty(ParameterQueue.ENABLE_SSL));
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(username);
        factory.setPassword(password);
        factory.setHost(host);
        factory.setPort(port);
        factory.setConnectionTimeout(connectionTimeout);
        if (ssl) {
            factory.useSslProtocol();
        }
        Connection connection = factory.newConnection();
        logger.info((Object)("New connection created using: username: " + username + ", host: " + host + ", port: " + port + ", connection timeout: " + connectionTimeout + " SSL enabled: " + ssl));
        return connection;
    }

    public static Channel getNewChannel() throws IOException {
        Channel channel = connection.createChannel();
        logger.info((Object)"New channel created using the default connection");
        return channel;
    }

    static {
        connectionTimeout = 2000;
    }
}

