/*
 * Decompiled with CFR 0.152.
 */
package omq.test.multiProcess;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;
import omq.test.multiProcess.Number;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClientTest {
    public Number remoteNumber;

    public ClientTest(String type) throws Exception {
        Properties env = new Properties();
        env.setProperty(ParameterQueue.USER_NAME, "guest");
        env.setProperty(ParameterQueue.USER_PASS, "guest");
        env.setProperty(ParameterQueue.SERVER_HOST, "127.0.0.1");
        env.setProperty(ParameterQueue.SERVER_PORT, "5672");
        env.setProperty(ParameterQueue.DURABLE_QUEUES, "false");
        env.setProperty(ParameterQueue.SERIALIZER_NAME, type);
        env.setProperty(ParameterQueue.ENABLECOMPRESSION, "false");
        env.setProperty(ParameterQueue.RPC_EXCHANGE, "rpc_exchange");
        env.setProperty(ParameterQueue.RPC_REPLY_QUEUE, "reply_queue");
        env.setProperty(ParameterQueue.EVENT_REPLY_QUEUE, "event_queue");
        Broker.initBroker(env);
        this.remoteNumber = Broker.lookup("number", Number.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{Serializer.java}, {Serializer.gson}, {Serializer.kryo}};
        return Arrays.asList(data);
    }

    @After
    public void stop() throws Exception {
        Broker.stopBroker();
    }

    @Test
    public void test() {
        int x = 10;
        this.remoteNumber.setNumber(x);
        int a = this.remoteNumber.getNumer();
        Assert.assertEquals((long)0L, (long)a);
        int b = this.remoteNumber.getNumer();
        Assert.assertEquals((long)x, (long)b);
        this.remoteNumber.setNumber(0);
    }
}

