/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Stack;
import org.apache.log4j.rule.AndRule;
import org.apache.log4j.rule.EqualsRule;
import org.apache.log4j.rule.ExistsRule;
import org.apache.log4j.rule.InequalityRule;
import org.apache.log4j.rule.LikeRule;
import org.apache.log4j.rule.NotEqualsRule;
import org.apache.log4j.rule.NotRule;
import org.apache.log4j.rule.OrRule;
import org.apache.log4j.rule.PartialTextMatchRule;
import org.apache.log4j.rule.Rule;

public final class RuleFactory {
    private static final RuleFactory FACTORY = new RuleFactory();
    private static final Collection RULES = new LinkedList();
    private static final String AND_RULE = "&&";
    private static final String OR_RULE = "||";
    private static final String NOT_RULE = "!";
    private static final String NOT_EQUALS_RULE = "!=";
    private static final String EQUALS_RULE = "==";
    private static final String PARTIAL_TEXT_MATCH_RULE = "~=";
    private static final String LIKE_RULE = "like";
    private static final String EXISTS_RULE = "exists";
    private static final String LESS_THAN_RULE = "<";
    private static final String GREATER_THAN_RULE = ">";
    private static final String LESS_THAN_EQUALS_RULE = "<=";
    private static final String GREATER_THAN_EQUALS_RULE = ">=";

    private RuleFactory() {
    }

    public static RuleFactory getInstance() {
        return FACTORY;
    }

    public boolean isRule(String symbol) {
        return symbol != null && RULES.contains(symbol.toLowerCase());
    }

    public Rule getRule(String symbol, Stack stack) {
        if (AND_RULE.equals(symbol)) {
            return AndRule.getRule(stack);
        }
        if (OR_RULE.equals(symbol)) {
            return OrRule.getRule(stack);
        }
        if (NOT_RULE.equals(symbol)) {
            return NotRule.getRule(stack);
        }
        if (NOT_EQUALS_RULE.equals(symbol)) {
            return NotEqualsRule.getRule(stack);
        }
        if (EQUALS_RULE.equals(symbol)) {
            return EqualsRule.getRule(stack);
        }
        if (PARTIAL_TEXT_MATCH_RULE.equals(symbol)) {
            return PartialTextMatchRule.getRule(stack);
        }
        if (RULES.contains(LIKE_RULE) && LIKE_RULE.equalsIgnoreCase(symbol)) {
            return LikeRule.getRule(stack);
        }
        if (EXISTS_RULE.equalsIgnoreCase(symbol)) {
            return ExistsRule.getRule(stack);
        }
        if (LESS_THAN_RULE.equals(symbol)) {
            return InequalityRule.getRule(LESS_THAN_RULE, stack);
        }
        if (GREATER_THAN_RULE.equals(symbol)) {
            return InequalityRule.getRule(GREATER_THAN_RULE, stack);
        }
        if (LESS_THAN_EQUALS_RULE.equals(symbol)) {
            return InequalityRule.getRule(LESS_THAN_EQUALS_RULE, stack);
        }
        if (GREATER_THAN_EQUALS_RULE.equals(symbol)) {
            return InequalityRule.getRule(GREATER_THAN_EQUALS_RULE, stack);
        }
        throw new IllegalArgumentException("Invalid rule: " + symbol);
    }

    static {
        RULES.add(AND_RULE);
        RULES.add(OR_RULE);
        RULES.add(NOT_RULE);
        RULES.add(NOT_EQUALS_RULE);
        RULES.add(EQUALS_RULE);
        RULES.add(PARTIAL_TEXT_MATCH_RULE);
        RULES.add(LIKE_RULE);
        RULES.add(EXISTS_RULE);
        RULES.add(LESS_THAN_RULE);
        RULES.add(GREATER_THAN_RULE);
        RULES.add(LESS_THAN_EQUALS_RULE);
        RULES.add(GREATER_THAN_EQUALS_RULE);
    }
}

