/*
 * Decompiled with CFR 0.152.
 */
package omq.test.temporal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import omq.client.annotation.AsyncMethod;
import omq.client.annotation.SyncMethod;
import omq.common.broker.Broker;
import omq.exception.RemoteException;
import omq.server.RemoteObject;
import omq.test.temporal.Client;

public class ClientImpl
extends RemoteObject
implements Client {
    private static final long serialVersionUID = 1L;
    private String id;
    private String profileInfo;
    private Map<String, Client> friendList;

    public ClientImpl(String id, String profileInfo) {
        this.id = id;
        this.profileInfo = profileInfo;
        this.friendList = new HashMap<String, Client>();
    }

    @Override
    @SyncMethod(retry=1, timeout=1500L)
    public String getID() {
        return this.id;
    }

    @Override
    @SyncMethod(retry=1, timeout=1500L)
    public String getProfileInfo() {
        return this.profileInfo;
    }

    @Override
    @SyncMethod(retry=1, timeout=1500L)
    public Set<String> getFriends() {
        return this.friendList.keySet();
    }

    @Override
    @AsyncMethod
    public void sendMessage(String message) {
        System.out.println("" + message);
    }

    @Override
    @AsyncMethod
    public void addContact(String contact) throws RemoteException {
        if (!this.id.equalsIgnoreCase(contact) && !this.friendList.containsKey(contact)) {
            Client client = Broker.lookup(contact, Client.class);
            this.friendList.put(contact, client);
        }
    }
}

