/*
 * Decompiled with CFR 0.152.
 */
package omq.common.message;

import java.io.Serializable;

public class Request
implements Serializable {
    private static final long serialVersionUID = 6366255840200365083L;
    private String method;
    private Object[] params;
    private String id;
    private boolean async = false;
    private transient long timeout;
    private transient int retries;

    public Request() {
    }

    public Request(String id, String method, Object[] params) {
        this.id = id;
        this.method = method;
        this.params = params;
    }

    private Request(String id, String method, boolean async, Object[] params) {
        this.id = id;
        this.method = method;
        this.async = async;
        this.params = params;
    }

    public static Request newSyncRequest(String id, String method, Object[] params) {
        return new Request(id, method, false, params);
    }

    public static Request newSyncRequest(String id, String method, Object[] params, int retries, long timeout) {
        Request req = new Request(id, method, false, params);
        req.setRetries(retries);
        req.setTimeout(timeout);
        return req;
    }

    public static Request newAsyncRequest(String id, String method, Object[] params) {
        return new Request(id, method, true, params);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }
}

