/*
 * Decompiled with CFR 0.152.
 */
package omq.common.broker;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import omq.Remote;
import omq.client.listener.ResponseListener;
import omq.client.proxy.MultiProxymq;
import omq.client.proxy.Proxymq;
import omq.common.util.OmqConnectionFactory;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;
import omq.exception.AlreadyBoundException;
import omq.exception.InitBrokerException;
import omq.exception.RemoteException;
import omq.server.RemoteObject;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Broker {
    private static final Logger logger = Logger.getLogger(Broker.class.getName());
    private Connection connection;
    private Channel channel;
    private ResponseListener responseListener;
    private Serializer serializer;
    private boolean clientStarted = false;
    private boolean connectionClosed = false;
    private Properties environment = null;
    private Map<String, RemoteObject> remoteObjs;
    private Map<String, Object> proxies = new Hashtable<String, Object>();
    private Map<String, Object> multiProxies = new Hashtable<String, Object>();

    public Broker(Properties env) throws Exception {
        URL log4jResource = Broker.class.getResource("/log4j.xml");
        DOMConfigurator.configure(log4jResource);
        this.remoteObjs = new HashMap<String, RemoteObject>();
        this.serializer = new Serializer(env);
        this.environment = env;
        this.connection = OmqConnectionFactory.getNewConnection(env);
        this.channel = this.connection.createChannel();
        this.addFaultTolerance();
        try {
            this.tryConnection(env);
        }
        catch (Exception e) {
            this.channel.close();
            this.connection.close();
            throw new InitBrokerException("The connection didn't work");
        }
    }

    public void stopBroker() throws Exception {
        logger.warn("Stopping broker");
        if (this.clientStarted) {
            this.responseListener.kill();
        }
        for (String reference : this.remoteObjs.keySet()) {
            this.unbind(reference);
        }
        this.closeConnection();
        this.clientStarted = false;
        this.connectionClosed = false;
        this.environment = null;
        this.remoteObjs = null;
    }

    public Connection getConnection() throws Exception {
        return this.connection;
    }

    public void closeConnection() throws IOException {
        logger.warn("Clossing connection");
        this.connectionClosed = true;
        this.connection.close();
        this.connectionClosed = false;
    }

    public Channel getChannel() throws Exception {
        return this.channel;
    }

    public Channel getNewChannel() throws IOException {
        return this.connection.createChannel();
    }

    public synchronized <T extends Remote> T lookup(String reference, Class<T> contract) throws RemoteException {
        try {
            if (!this.clientStarted) {
                this.initClient();
            }
            if (!this.proxies.containsKey(reference)) {
                Proxymq proxy = new Proxymq(reference, contract, this);
                Class[] array = new Class[]{contract};
                Object newProxy = Proxy.newProxyInstance(contract.getClassLoader(), array, (InvocationHandler)proxy);
                this.proxies.put(reference, newProxy);
                return (T)((Remote)newProxy);
            }
            return (T)((Remote)this.proxies.get(reference));
        }
        catch (Exception e) {
            throw new RemoteException(e);
        }
    }

    public synchronized <T extends Remote> T lookupMulti(String reference, Class<T> contract) throws RemoteException {
        try {
            if (!this.multiProxies.containsKey(reference)) {
                MultiProxymq proxy = new MultiProxymq(reference, contract, this);
                Class[] array = new Class[]{contract};
                Object newProxy = Proxy.newProxyInstance(contract.getClassLoader(), array, (InvocationHandler)proxy);
                this.multiProxies.put(reference, newProxy);
                return (T)((Remote)newProxy);
            }
            return (T)((Remote)this.multiProxies.get(reference));
        }
        catch (Exception e) {
            throw new RemoteException(e);
        }
    }

    public void bind(String reference, RemoteObject remote) throws RemoteException, AlreadyBoundException {
        this.bind(reference, remote, this.environment);
    }

    public void bind(String reference, RemoteObject remote, Properties env) throws RemoteException, AlreadyBoundException {
        if (this.remoteObjs.containsKey(reference)) {
            throw new AlreadyBoundException(reference);
        }
        try {
            remote.startRemoteObject(reference, this, env);
            this.remoteObjs.put(reference, remote);
        }
        catch (Exception e) {
            throw new RemoteException(e);
        }
    }

    public void unbind(String reference) throws RemoteException, IOException {
        if (!this.remoteObjs.containsKey(reference)) {
            throw new RemoteException("The object referenced by 'reference' does not exist in the Broker");
        }
        RemoteObject remote = this.remoteObjs.get(reference);
        remote.kill();
    }

    private synchronized void initClient() throws Exception {
        if (this.responseListener == null) {
            this.responseListener = new ResponseListener(this);
            this.responseListener.start();
            this.clientStarted = true;
        }
    }

    public void tryConnection(Properties env) throws Exception {
        String exchange;
        Channel channel = this.connection.createChannel();
        String message = "ping";
        String queueName = exchange = env.getProperty(ParameterQueue.USER_NAME) + "ping";
        String routingKey = "routingKey";
        channel.exchangeDeclare(exchange, "direct");
        channel.queueDeclare(queueName, false, false, false, null);
        channel.queueBind(queueName, exchange, routingKey);
        channel.basicPublish(exchange, routingKey, null, message.getBytes());
        QueueingConsumer consumer = new QueueingConsumer(channel);
        channel.basicConsume(queueName, true, consumer);
        QueueingConsumer.Delivery delivery = consumer.nextDelivery(1000L);
        channel.exchangeDelete(exchange);
        channel.queueDelete(queueName);
        channel.close();
        if (!message.equalsIgnoreCase(new String(delivery.getBody()))) {
            throw new IOException("Ping initialitzation has failed");
        }
    }

    private void addFaultTolerance() {
        this.connection.addShutdownListener(new ShutdownListener(){

            @Override
            public void shutdownCompleted(ShutdownSignalException cause) {
                logger.warn("Shutdown message received. Cause: " + cause.getMessage());
                if (!Broker.this.connectionClosed) {
                    if (cause.isHardError()) {
                        if (Broker.this.connection.isOpen()) {
                            try {
                                Broker.this.connection.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            Broker.this.connection = OmqConnectionFactory.getNewWorkingConnection(Broker.this.environment);
                            Broker.this.channel = Broker.this.connection.createChannel();
                            Broker.this.addFaultTolerance();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        Channel channel = (Channel)cause.getReference();
                        if (channel.isOpen()) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    public ResponseListener getResponseListener() {
        return this.responseListener;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }
}

