/*
 * Decompiled with CFR 0.152.
 */
package omq.client.proxy;

import com.rabbitmq.client.AMQP;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import omq.Remote;
import omq.client.annotation.AsyncMethod;
import omq.client.annotation.MultiMethod;
import omq.client.annotation.SyncMethod;
import omq.client.listener.ResponseListener;
import omq.common.broker.Broker;
import omq.common.message.Request;
import omq.common.message.Response;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializer;
import omq.exception.OmqException;
import omq.exception.RetryException;
import omq.exception.TimeoutException;
import org.apache.log4j.Logger;

public class Proxymq
implements InvocationHandler,
Remote {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Proxymq.class.getName());
    private static final String multi = "multi#";
    private String uid;
    private transient String exchange;
    private transient String multiExchange;
    private transient String replyQueueName;
    private transient String serializerType;
    private transient Broker broker;
    private transient ResponseListener rListener;
    private transient Serializer serializer;
    private transient Properties env;
    private transient Integer deliveryMode = null;
    private transient Map<String, byte[]> results;
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();

    public Proxymq(String uid, Class<?> clazz, Broker broker) throws Exception {
        this.uid = uid;
        this.broker = broker;
        this.rListener = broker.getResponseListener();
        this.serializer = broker.getSerializer();
        this.env = broker.getEnvironment();
        this.exchange = this.env.getProperty(ParameterQueue.RPC_EXCHANGE);
        this.multiExchange = multi + uid;
        this.replyQueueName = this.env.getProperty(ParameterQueue.RPC_REPLY_QUEUE);
        this.serializerType = this.env.getProperty(ParameterQueue.PROXY_SERIALIZER, "java");
        if (this.env.getProperty(ParameterQueue.DELIVERY_MODE) != null) {
            this.deliveryMode = Integer.parseInt(this.env.getProperty(ParameterQueue.DELIVERY_MODE));
        }
        this.results = new HashMap<String, byte[]>();
        this.rListener.registerProxy(this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        String methodName = method.getName();
        if (method.getDeclaringClass().equals(Remote.class) && methodName.equals("getRef")) {
            return this.getRef();
        }
        Request request = this.createRequest(method, arguments);
        Object response = null;
        if (request.isAsync()) {
            this.publishMessage(request, this.replyQueueName);
        } else {
            response = this.publishSyncRequest(request, method.getReturnType());
        }
        return response;
    }

    private void publishMessage(Request request, String replyQueueName) throws Exception {
        String routingkey;
        String exchange;
        String corrId = request.getId();
        if (request.isMulti()) {
            exchange = this.multiExchange;
            routingkey = "";
        } else {
            exchange = this.exchange;
            routingkey = this.uid;
        }
        AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().appId(this.uid).correlationId(corrId).replyTo(replyQueueName).type(this.serializerType).deliveryMode(this.deliveryMode).build();
        byte[] bytesRequest = this.serializer.serialize(this.serializerType, request);
        this.broker.getChannel().basicPublish(exchange, routingkey, props, bytesRequest);
        logger.debug("Proxymq: " + this.uid + " invokes '" + request.getMethod() + "' , corrID: " + corrId + ", exchange: " + exchange + ", replyQueue: " + replyQueueName + ", serializerType: " + this.serializerType + ", multi call: " + request.isMulti() + ", async call: " + request.isAsync() + ", delivery mode: " + this.deliveryMode);
    }

    private Object publishSyncRequest(Request request, Class<?> type) throws Exception {
        String corrId = request.getId();
        int retries = request.getRetries();
        long timeout = request.getTimeout();
        for (int i = 0; i < retries; ++i) {
            try {
                this.publishMessage(request, this.replyQueueName);
                if (request.isMulti()) {
                    return this.getResults(corrId, request.getWait(), timeout, type);
                }
                return this.getResult(corrId, timeout, type);
            }
            catch (TimeoutException te) {
                logger.error(te);
                continue;
            }
        }
        throw new RetryException(retries, timeout);
    }

    private Request createRequest(Method method, Object[] arguments) {
        String corrId = UUID.randomUUID().toString();
        String methodName = method.getName();
        boolean multi = false;
        int wait = 0;
        if (method.getAnnotation(MultiMethod.class) != null) {
            multi = true;
            wait = method.getAnnotation(MultiMethod.class).waitNum();
        }
        if (method.getAnnotation(AsyncMethod.class) == null) {
            int retries = 1;
            long timeout = ParameterQueue.DEFAULT_TIMEOUT;
            if (method.getAnnotation(SyncMethod.class) != null) {
                SyncMethod sync = method.getAnnotation(SyncMethod.class);
                retries = sync.retry();
                timeout = sync.timeout();
            }
            return Request.newSyncRequest(corrId, methodName, arguments, retries, timeout, multi, wait);
        }
        return Request.newAsyncRequest(corrId, methodName, arguments, multi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getResult(String corrId, long timeout, Class<?> type) throws Exception {
        Response resp = null;
        long localTimeout = timeout;
        long start = System.currentTimeMillis();
        Map<String, byte[]> map = this.results;
        synchronized (map) {
            while (!this.results.containsKey(corrId) && timeout - localTimeout >= 0L) {
                this.results.wait(localTimeout);
                localTimeout = System.currentTimeMillis() - start;
            }
            if (timeout - localTimeout <= 0L) {
                throw new TimeoutException("Timeout exception time: " + timeout);
            }
            resp = this.serializer.deserializeResponse(this.results.get(corrId), type);
            this.results.put(corrId, null);
        }
        if (resp.getError() != null) {
            OmqException error = resp.getError();
            String name = error.getType();
            String message = error.getMessage();
            throw (Exception)Class.forName(name).getConstructor(String.class).newInstance(message);
        }
        return resp.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getResults(String corrId, int wait, long timeout, Class<?> type) throws Exception {
        Map<String, byte[]> map;
        Response resp = null;
        Class<?> actualType = type.getComponentType();
        Object array = Array.newInstance(actualType, wait);
        long localTimeout = timeout;
        long start = System.currentTimeMillis();
        for (int i = 0; i < wait; ++i) {
            map = this.results;
            synchronized (map) {
                while (!this.results.containsKey(corrId) && timeout - localTimeout >= 0L) {
                    this.results.wait(localTimeout);
                    localTimeout = System.currentTimeMillis() - start;
                }
                if (timeout - localTimeout <= 0L) {
                    throw new TimeoutException("Timeout exception time: " + timeout);
                }
                resp = this.serializer.deserializeResponse(this.results.remove(corrId), actualType);
                Array.set(array, i, resp.getResult());
                continue;
            }
        }
        map = this.results;
        synchronized (map) {
            this.results.put(corrId, null);
        }
        return array;
    }

    public Map<String, byte[]> getResults() {
        return this.results;
    }

    @Override
    public String getRef() {
        return this.uid;
    }

    static {
        primitiveClasses.put("byte", Byte.class);
        primitiveClasses.put("short", Short.class);
        primitiveClasses.put("char", Character.class);
        primitiveClasses.put("int", Integer.class);
        primitiveClasses.put("long", Long.class);
        primitiveClasses.put("float", Float.class);
        primitiveClasses.put("double", Double.class);
    }
}

