/*
 * Decompiled with CFR 0.152.
 */
package omq.common.util;

import java.io.IOException;
import java.util.Properties;
import omq.common.message.Request;
import omq.common.message.Response;
import omq.common.util.ParameterQueue;
import omq.common.util.Serializers.GsonImp;
import omq.common.util.Serializers.ISerializer;
import omq.common.util.Serializers.JavaImp;
import omq.common.util.Serializers.KryoImp;
import omq.common.util.Zipper;
import omq.exception.SerializerException;
import omq.server.RemoteObject;

public class Serializer {
    public static final String KRYO = "kryo";
    public static final String JAVA = "java";
    public static final String GSON = "gson";
    public ISerializer serializer;
    private ISerializer kryoSerializer;
    private ISerializer javaSerializer;
    private ISerializer gsonSerializer;
    private Properties env;

    public Serializer(Properties env) {
        this.env = env;
    }

    private Boolean getEnableCompression() {
        return Boolean.valueOf(this.env.getProperty(ParameterQueue.ENABLE_COMPRESSION, "false"));
    }

    public ISerializer getInstance() throws SerializerException {
        if (this.serializer == null) {
            try {
                String className = this.env.getProperty(ParameterQueue.PROXY_SERIALIZER, JAVA);
                if (className == null || className.isEmpty()) {
                    throw new ClassNotFoundException("Class name is null or empty.");
                }
                this.serializer = this.getInstance(className);
            }
            catch (Exception ex) {
                throw new SerializerException(ex.getMessage(), ex);
            }
        }
        return this.serializer;
    }

    public ISerializer getInstance(String type) throws SerializerException {
        if (KRYO.equals(type)) {
            if (this.kryoSerializer == null) {
                this.kryoSerializer = new KryoImp();
            }
            return this.kryoSerializer;
        }
        if (GSON.equals(type)) {
            if (this.gsonSerializer == null) {
                this.gsonSerializer = new GsonImp();
            }
            return this.gsonSerializer;
        }
        if (JAVA.equals(type)) {
            if (this.javaSerializer == null) {
                this.javaSerializer = new JavaImp();
            }
            return this.javaSerializer;
        }
        throw new SerializerException("Serializer not found.");
    }

    public byte[] serialize(String type, Object obj) throws SerializerException {
        ISerializer instance = this.getInstance(type);
        Boolean enableCompression = this.getEnableCompression();
        if (enableCompression.booleanValue()) {
            byte[] objSerialized = instance.serialize(obj);
            try {
                return Zipper.zip(objSerialized);
            }
            catch (IOException e) {
                throw new SerializerException(e.getMessage(), e);
            }
        }
        return instance.serialize(obj);
    }

    public byte[] serialize(Object obj) throws SerializerException {
        ISerializer instance = this.getInstance();
        Boolean enableCompression = this.getEnableCompression();
        if (enableCompression.booleanValue()) {
            byte[] objSerialized = instance.serialize(obj);
            try {
                return Zipper.zip(objSerialized);
            }
            catch (IOException e) {
                throw new SerializerException(e.getMessage(), e);
            }
        }
        return instance.serialize(obj);
    }

    public Request deserializeRequest(String type, byte[] bytes, RemoteObject obj) throws SerializerException {
        ISerializer instance = this.getInstance(type);
        Boolean enableCompression = this.getEnableCompression();
        if (enableCompression.booleanValue()) {
            try {
                byte[] unZippedBytes = Zipper.unzip(bytes);
                return instance.deserializeRequest(unZippedBytes, obj);
            }
            catch (IOException e) {
                throw new SerializerException(e.getMessage(), e);
            }
        }
        return instance.deserializeRequest(bytes, obj);
    }

    public Response deserializeResponse(byte[] bytes, Class<?> type) throws SerializerException {
        ISerializer instance = this.getInstance();
        Boolean enableCompression = this.getEnableCompression();
        if (enableCompression.booleanValue()) {
            try {
                byte[] unZippedBytes = Zipper.unzip(bytes);
                return instance.deserializeResponse(unZippedBytes, type);
            }
            catch (IOException e) {
                throw new SerializerException(e.getMessage(), e);
            }
        }
        return instance.deserializeResponse(bytes, type);
    }
}

