package omq.test.multiThread2;

import java.util.Properties;

import omq.common.broker.Broker;
import omq.common.util.ParameterQueue;

import org.junit.BeforeClass;
import org.junit.Test;

public class PrintTest {
	public static String NAME = "print";

	@BeforeClass
	public static void Server() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");
		env.setProperty(ParameterQueue.NUM_THREADS, "2");

		PrintImpl print = new PrintImpl(1);
		Broker broker = new Broker(env);
		broker.bind(NAME, print);

		PrintImpl print2 = new PrintImpl(2);
		Broker broker2 = new Broker(env);
		broker2.bind(NAME, print2);

	}

	@Test
	public void test() throws Exception {
		Properties env = new Properties();
		env.setProperty(ParameterQueue.USER_NAME, "guest");
		env.setProperty(ParameterQueue.USER_PASS, "guest");

		// Get host info of rabbimq (where it is)
		env.setProperty(ParameterQueue.RABBIT_HOST, "127.0.0.1");
		env.setProperty(ParameterQueue.RABBIT_PORT, "5672");

		Broker broker = new Broker(env);
		Print print = broker.lookup(NAME, Print.class);

		print.printSleep(1, 3000);
		Thread.sleep(100);
		print.printSleep(2, 2000);
		Thread.sleep(100);
		print.printSleep(3, 1000);
		Thread.sleep(100);
		print.printSleep(4, 4000);

		print.printSleep(3, 5000);
		Thread.sleep(100);
		print.printSleep(2, 5000);
		Thread.sleep(100);
		print.printSleep(1, 5000);
		Thread.sleep(100);
		print.printSleep(4, 5000);

		Thread.sleep(6000);

	}

}
